/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.autocorrect.gui;

import club.sk1er.autocorrect.AutoCorrect;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.patterns.PatternRule;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class AutoCorrectEnabledInput
extends GuiTextField {
    private AtomicBoolean updating = new AtomicBoolean();
    private List<RuleMatch> currentIssues = new ArrayList<RuleMatch>();
    private long lastTypeTime = System.currentTimeMillis();
    private List<String> suggestions = null;
    private RuleMatch currentMatch = null;
    private int selectedSuggestion = -1;
    private final List<String> NO_SUGGESTIONS = Lists.asList((Object)"No suggestions!", (Object[])new String[0]);
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private boolean iterating = false;
    private int iterIndex = -1;

    public AutoCorrectEnabledInput(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
        super(componentId, fontrendererObj, x, y, par5Width, par6Height);
    }

    public void func_146194_f() {
        super.func_146194_f();
        if (this.func_146176_q() && System.currentTimeMillis() - this.lastTypeTime > 250L) {
            this.updateSpellcheck();
            this.lastTypeTime += 20000L;
        }
        String s = this.field_146211_a.func_78269_a(this.field_146216_j.substring(this.field_146225_q), this.func_146200_o());
        if (this.suggestions != null) {
            String longest = "";
            List<String> realSuggestions = this.suggestions.size() == 0 ? this.NO_SUGGESTIONS : this.suggestions;
            for (String sugg : realSuggestions) {
                if (sugg.length() <= longest.length()) continue;
                longest = sugg;
            }
            int boxWidth = 3 + this.field_146211_a.func_78256_a(longest);
            int boxHeight = 3 + realSuggestions.size() * (this.field_146211_a.field_78288_b + 2);
            int bottomY = this.field_146210_g + (this.field_146219_i - 8) / 2 - 5;
            int charOffset = this.field_146224_r - this.field_146225_q;
            int x = this.field_146209_f + this.field_146211_a.func_78256_a(s.substring(0, charOffset));
            Gui.func_73734_a((int)x, (int)(bottomY - boxHeight), (int)(x + boxWidth), (int)bottomY, (int)-16777216);
            int startY = bottomY - 2 - this.field_146211_a.field_78288_b;
            int mX = Mouse.getEventX() * this.field_146218_h / Minecraft.func_71410_x().field_71443_c;
            int mY = Minecraft.func_71410_x().field_71462_r.field_146295_m - Mouse.getEventY() * Minecraft.func_71410_x().field_71462_r.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            if (mX >= x && mX <= x + boxWidth && mY >= bottomY - boxHeight && mY <= bottomY && (mX != this.lastMouseX || mY != this.lastMouseY)) {
                int insideY = mY - (bottomY - boxHeight);
                int clickIndex = insideY / (this.field_146211_a.field_78288_b + 2);
                this.selectedSuggestion = this.suggestions.size() - 1 - clickIndex;
                this.lastMouseX = mX;
                this.lastMouseY = mY;
            }
            int index = 0;
            for (String sugg : realSuggestions) {
                int color = index == this.selectedSuggestion ? -529383 : -1184275;
                this.field_146211_a.func_78276_b(sugg, x + 2, startY, color);
                startY -= this.field_146211_a.field_78288_b + 2;
                ++index;
            }
        }
        if (this.currentIssues != null) {
            int allowedFrom = this.field_146225_q;
            int allowedTo = this.field_146225_q + s.length();
            int beginX = this.field_146215_m ? this.field_146209_f + 4 : this.field_146209_f;
            int y = this.field_146215_m ? this.field_146210_g + (this.field_146219_i - 8) / 2 : this.field_146210_g;
            y += this.field_146211_a.field_78288_b + 1;
            for (RuleMatch issue : this.currentIssues) {
                if (issue.getFromPos() < allowedFrom || issue.getToPos() > allowedTo) continue;
                int offX = this.field_146211_a.func_78256_a(this.field_146216_j.substring(0, issue.getFromPos()));
                int xLength = this.field_146211_a.func_78256_a(this.field_146216_j.substring(issue.getFromPos(), issue.getToPos()));
                Gui.func_73734_a((int)(beginX + offX), (int)y, (int)(beginX + offX + xLength), (int)(y + 1), (int)-1039350);
            }
        }
    }

    public void func_146180_a(String p_146180_1_) {
        super.func_146180_a(p_146180_1_);
        this.currentIssues = null;
        this.suggestions = null;
        this.currentMatch = null;
        this.selectedSuggestion = -1;
        this.iterating = false;
        this.iterIndex = -1;
        this.updateSpellcheck();
    }

    public void func_146191_b(String p_146191_1_) {
        super.func_146191_b(p_146191_1_);
        if (this.field_146224_r >= this.field_146216_j.length()) {
            return;
        }
        this.currentIssues = null;
        this.suggestions = null;
        this.currentMatch = null;
        this.selectedSuggestion = -1;
        this.updateSpellcheck();
    }

    public boolean func_146201_a(char p_146201_1_, int p_146201_2_) {
        if (p_146201_2_ == 1 && (this.iterating || this.suggestions != null)) {
            this.iterating = false;
            this.iterIndex = -1;
            this.updateSpellcheck();
            this.currentMatch = null;
            this.suggestions = null;
            this.selectedSuggestion = -1;
            return true;
        }
        if (p_146201_2_ == 28 && (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) && this.currentIssues != null && this.currentIssues.size() > 0) {
            if (this.iterating) {
                ++this.iterIndex;
                if (this.iterIndex >= this.currentIssues.size()) {
                    this.iterating = false;
                    this.iterIndex = -1;
                    this.updateSpellcheck();
                    this.func_146190_e(this.field_146216_j.length());
                    return true;
                }
                this.field_146224_r = this.currentIssues.get(this.iterIndex).getFromPos();
                this.func_146199_i(this.field_146224_r);
                this.generateSuggestions(this.field_146224_r);
                return true;
            }
            this.iterating = true;
            this.iterIndex = 0;
            this.field_146224_r = this.currentIssues.get(this.iterIndex).getFromPos();
            this.func_146199_i(this.field_146224_r);
            this.generateSuggestions(this.field_146224_r);
            return true;
        }
        if ((p_146201_2_ == 15 || p_146201_2_ == 28) && this.suggestions != null) {
            if (this.suggestions.size() - 1 < this.selectedSuggestion || this.selectedSuggestion < 0) {
                return true;
            }
            this.completeSuggestion();
            return true;
        }
        boolean typed = super.func_146201_a(p_146201_1_, p_146201_2_);
        if (p_146201_2_ == 57) {
            this.updateSpellcheck();
        } else {
            if (p_146201_2_ == 200 && this.suggestions != null) {
                this.selectedSuggestion = Math.min(this.selectedSuggestion + 1, this.suggestions.size() - 1);
                return true;
            }
            if (p_146201_2_ == 208 && this.suggestions != null) {
                this.selectedSuggestion = Math.max(this.selectedSuggestion - 1, 0);
                return true;
            }
        }
        if (typed) {
            this.lastTypeTime = System.currentTimeMillis();
        }
        return typed;
    }

    public void func_146192_a(int mX, int mY, int button) {
        boolean flag;
        super.func_146192_a(mX, mY, button);
        boolean bl = flag = mX >= this.field_146209_f && mX < this.field_146209_f + this.field_146218_h && mY >= this.field_146210_g && mY < this.field_146210_g + this.field_146219_i;
        if (this.suggestions != null) {
            int charOffset;
            String longest = "";
            for (String sugg : this.suggestions) {
                if (sugg.length() <= longest.length()) continue;
                longest = sugg;
            }
            int boxWidth = 4 + this.field_146211_a.func_78256_a(longest);
            int boxHeight = 4 + this.suggestions.size() * (this.field_146211_a.field_78288_b + 2);
            int bottomY = this.field_146210_g + (this.field_146219_i - 8) / 2 - 4;
            String s = this.field_146211_a.func_78269_a(this.field_146216_j.substring(this.field_146225_q), this.func_146200_o());
            int x = this.field_146209_f + this.field_146211_a.func_78256_a(s.substring(0, charOffset = this.field_146224_r - this.field_146225_q));
            if (mX < x || mX > x + boxWidth || mY < bottomY - boxHeight || mY > bottomY) {
                this.suggestions = null;
            } else if (this.selectedSuggestion < this.suggestions.size() && this.selectedSuggestion >= 0) {
                this.completeSuggestion();
            }
        }
        if (this.func_146206_l() && flag && button == 1) {
            int i = mX - this.field_146209_f;
            if (this.func_146181_i()) {
                i -= 4;
            }
            String s = this.field_146211_a.func_78269_a(this.func_146179_b().substring(this.field_146225_q), this.func_146200_o());
            int clickPosition = this.field_146211_a.func_78269_a(s, i).length() + this.field_146225_q;
            this.func_146190_e(clickPosition);
            this.updateSpellcheck();
            this.generateSuggestions(clickPosition);
        }
    }

    private void completeSuggestion() {
        try {
            String oldText = this.field_146216_j.substring(this.currentMatch.getFromPos(), this.currentMatch.getToPos());
            String newText = this.suggestions.get(this.selectedSuggestion);
            this.field_146216_j = this.field_146216_j.substring(0, this.currentMatch.getFromPos()) + newText + this.field_146216_j.substring(this.currentMatch.getToPos());
            int lengthDiff = newText.length() - oldText.length();
            this.currentIssues.removeIf(it -> it.equals(this.currentMatch));
            this.currentIssues.forEach(it -> {
                if (it.getFromPos() > this.currentMatch.getToPos()) {
                    it.setOffsetPosition(it.getFromPos() + lengthDiff, it.getToPos() + lengthDiff);
                }
            });
            RuleMatch tmp = this.currentMatch;
            this.currentMatch = null;
            this.suggestions = null;
            this.selectedSuggestion = -1;
            if (!this.iterating) {
                this.func_146190_e(tmp.getFromPos() + newText.length());
            } else {
                if (this.iterIndex >= this.currentIssues.size()) {
                    this.iterating = false;
                    this.iterIndex = -1;
                    this.func_146190_e(this.field_146216_j.length());
                    this.updateSpellcheck();
                    return;
                }
                this.func_146190_e(this.currentIssues.get(this.iterIndex).getFromPos());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_146190_e(int p_146190_1_) {
        super.func_146190_e(p_146190_1_);
        if (this.currentMatch != null) {
            if (p_146190_1_ < this.currentMatch.getFromPos() || p_146190_1_ > this.currentMatch.getToPos()) {
                this.currentMatch = null;
                this.suggestions = null;
                this.selectedSuggestion = -1;
            }
        } else if (this.currentIssues != null) {
            this.generateSuggestions(p_146190_1_);
        }
    }

    private void generateSuggestions(int p_146190_1_) {
        for (RuleMatch match : this.currentIssues) {
            if (match.getFromPos() > p_146190_1_ || p_146190_1_ > match.getToPos()) continue;
            this.suggestions = match.getSuggestedReplacements().stream().limit(20L).collect(Collectors.toList());
            this.currentMatch = match;
            this.selectedSuggestion = 0;
            break;
        }
    }

    private void updateSpellcheck() {
        if (this.updating.compareAndSet(false, true)) {
            new Thread(() -> {
                try {
                    boolean validSuggestions;
                    this.currentIssues = AutoCorrect.INSTANCE.checker.check(this.func_146179_b()).stream().filter(it -> {
                        if (it.getRule() instanceof UppercaseSentenceStartRule) {
                            return false;
                        }
                        if (it.getRule() instanceof PatternRule) {
                            return !((PatternRule)it.getRule()).getFullId().startsWith("I_LOWERCASE");
                        }
                        return true;
                    }).collect(Collectors.toList());
                    boolean bl = validSuggestions = this.currentMatch != null && this.currentIssues.stream().anyMatch(it -> this.field_146224_r >= it.getFromPos() && this.field_146224_r <= it.getToPos() && it.getSuggestedReplacements().equals(this.currentMatch.getSuggestedReplacements()));
                    if (!validSuggestions) {
                        this.currentMatch = null;
                        this.suggestions = null;
                        this.selectedSuggestion = -1;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.updating.set(false);
                }
            }).start();
        }
    }
}

